// Header File
// Created 30/12/2003; 17:32:03
//Gestion de simples Bonus

//Pas de bonus 3 Billes
#define Bonus_No3Billes(x)				Racket [x]->Billes_3=FALSE;

//Application du Bonus rducteur de vitesse
void Bonus_Slow (unsigned char item)
{
	////Si double raquette, appartenance
	//if (Racket [item]->isDoubleRacket) item=Racket [item]->parent;
	
	//Parcours Bille
	for (int i=0;i<nbrBille;i++)
	{
		//La Bille appartient  la raquette
		if (Bille [i]->n_racket==item)
			ChangeBilleSpeed (i,DEFAULT_SPEED_BILLES);
	}
}

//Applique Bonus Bille de feu
void Bonus_BilleFire (unsigned char item)
{
	////Si double raquette, appartenance
	//if (Racket [item]->isDoubleRacket) item=Racket [item]->parent;
	
	//Parcours Bille
	for (int i=0;i<nbrBille;i++)
	{
		//La Bille appartient  la raquette
		if (Bille [i]->n_racket==item)
			Bille [i]->type=BILLE_FIRE;
	}
}

//Applique Bonus Bille normal
void Bonus_BilleNoFire (unsigned char item)
{
	////Si double raquette, appartenance
	//if (Racket [item]->isDoubleRacket) item=Racket [item]->parent;
	
	//Parcours Bille
	for (int i=0;i<nbrBille;i++)
	{
		//La Bille appartient  la raquette
		if (Bille [i]->n_racket==item)
			Bille [i]->type=BILLE_NOFIRE;
	}
}

//Ajoute 5 Billes
void Bonus_Add5Billes (unsigned char item)
{
	unsigned char i=0;
	short x, y;
	short speed;
	BOOL fire;
	BOOL flag=FALSE;
	
	////Si double raquette, appartenance
	//if (Racket [item]->isDoubleRacket) item=Racket [item]->parent;
	
	//Bille la plus proche
	for (;i<nbrBille;i++)
	{
		if (Bille [i]->n_racket==item) {
			flag=TRUE;
			break;}
	}
	
	//Au moins une bille
	if (flag)
	{
		x=Bille [i]->xpos;
		y=Bille [i]->ypos;
		speed=Bille [i]->speed;
		fire=Bille [i]->type;
	}
	else
	{
		x=Racket [item]->xpos+(Racket [item]->size_x/2); y=Racket [item]->ypos-BILLE_SIZEY;
		speed=DEFAULT_SPEED_BILLES;
		fire=BILLE_NOFIRE;
		NewBille (x,y,45,speed,fire,item);
		i=nbrBille-1;
	}
	
	//Ajoute Billes
	NewBille (x-BILLE_SIZEX,y-1,96,speed,fire,item);
	NewBille (x+BILLE_SIZEX,y-1,32,speed,fire,item);
	
	NewBille (x,y-BILLE_SIZEY,128+Bille [i]->rad,speed,fire,item);
	
	NewBille (x-3,y+BILLE_SIZEY,160,speed,fire,item);
	NewBille (x+3,y+BILLE_SIZEY,224,speed,fire,item);
}

//Ajoute 3 Billes qui ce regnre
void Bonus_Add3Billes (unsigned char item)
{
	short x,y,speed;
	BOOL fire;
	unsigned char j=0;
	BOOL flag=FALSE;
	
	//Si Bonus existe dj
	if (Racket [item]->Billes_3) return;
	
	//Active Bonus 3 Billes
	Racket [item]->Billes_3=TRUE;
	
	//Active sur Double Racket
	if (Racket [item]->double_racket)
		Racket [Racket [item]->double_racket_n]->Billes_3=TRUE;
	
	//Recherche une Bille
	for (;j<nbrBille;j++)
	{
		//Si Bille quitter
		if (Bille [j]->n_racket==item) {
			flag=TRUE;
			break;}
	}
				
	//Au moins une bille
	if (flag)
	{
		x=Bille [j]->xpos;	y=Bille [j]->ypos;
		speed=Bille [j]->speed;
		fire=Bille [j]->type;
	}
	else
	{
		x=Racket [item]->xpos+(Racket [item]->size_x/2); y=Racket [item]->ypos-BILLE_SIZEY;
		speed=DEFAULT_SPEED_BILLES;
		fire=BILLE_NOFIRE;
		NewBille (x,y,45,speed,fire,item);
	}
	
	//Ajoute Billes
	NewBille (x-BILLE_SIZEX,y-1,96,speed,fire,item);
	NewBille (x+BILLE_SIZEX,y-1,32,speed,fire,item);
}

//Gestion du Bonus 3 Billes
void Bonus_3Billes (void)
{
	unsigned char nbille;
	short x,y,speed;
	BOOL fire;
	unsigned char j=0;
	BOOL sticked=FALSE;
		
	//Parcours rackets
	for (int i=0;i<nbrRacket;i++)
	{
		//Si Bonus activ
		if (Racket [i]->Billes_3)
		{
			nbille=0;
			
			//Compte le nombre de Billes
			for (j=0;j<nbrBille;j++)
			{
				//Si Bille appartient  racket
				if (Bille [j]->n_racket==i)
					nbille++;
					
				//Si 3 billes quitter
				if (nbille==3) break;
			}
			
			//Si pas le compte ajouter billes
			//Si diffrent de 0 et infrieur  3
			if ((nbille<3) && (nbille) && (Racket [i]->touch))
			{
				//Recherche une Bille
				for (j=0;j<nbrBille;j++)
				{
					//Si Bille quitter
					if (Bille [j]->n_racket==i)
						break;
				}
				
				//Coordonnes
				x=Bille [j]->xpos;	y=Bille [j]->ypos;
				speed=Bille [j]->speed;
				fire=Bille [j]->type;
				
				//Colle
				sticked=FALSE;
				if (Bille [j]->sticked) {
					sticked=TRUE;
					speed=Bille [j]->save_speed;}
				
				//Ajoute Bille manquante
				for (int j=0;j<3-nbille;j++) {
					//NewBille (x+BILLE_SIZEX,y-1,32+(j*64),speed,fire,i);
					NewBille (Racket [i]->xpos+(Racket [i]->size_x/2), Racket [i]->ypos-BILLE_SIZEY, 32+(j*64), speed, fire,i);
					//Si Bonus colle coller toutes les Billes
					if (sticked) Bonus_RacketColle (i,nbrBille-1);}
			} 
		}
	}
}